<?php
$cache='/var/tmp/thumbs/';

$msize = intval($_REQUEST['size']);
if (!$msize) $msize = 100;
define('MAX_WIDTH', $msize);
define('MAX_HEIGHT', $msize);

# Get image location
$image_file = str_replace('..', '', $_GET['image']);
if (!empty($_GET['path']))
	$image_path = $_GET['path'] . "$image_file";
else
	$image_path = $image_file;

# Detect file extension
$ext = strtolower(end(explode('.', $image_path)));
if ($ext == 'jpg' || $ext == 'jpeg')
	$imgtype = 'jpg';
else if ($ext == 'png')
	$imgtype = 'png';
	# Only if your version of GD includes GIF support
else if ($ext == 'gif')
	if (function_exists('imagecreatefromgif'))
		$imgtype = 'gif';
else if ($ext == 'bmp')
	$imgtype = 'bmp';

# Create cache dir
if(!file_exists($cache))
	mkdir($cache,0700);

# If file doesnt exist => create resized image and cache it
if( !file_exists($cache.md5($image_path.$msize)) ) {

	# Load image
	$img = null;
	$ext = strtolower(end(explode('.', $image_path)));
	if ($ext == 'jpg' || $ext == 'jpeg')
		$img = @imagecreatefromjpeg($image_path);
	
	else if ($ext == 'png')
		$img = @imagecreatefrompng($image_path);
		
	# Only if your version of GD includes GIF support
	else if ($ext == 'gif')
		if (function_exists('imagecreatefromgif'))
			$img = @imagecreatefromgif($image_path);
		
	else if ($ext == 'bmp')
		$img = @imagecreatefromwbmp($image_path);

	# If an image was successfully loaded, test the image for size
	if ($img) {

		# Get image size and scale ratio
		$width = imagesx($img);
		$height = imagesy($img);
		$scale = min(MAX_WIDTH/$width, MAX_HEIGHT/$height);
		
	    	# If the image is larger than the max shrink it
		if ($scale < 1) {
			$new_width = floor($scale*$width);
			$new_height = floor($scale*$height);

        		# Create a new temporary image
	        	$tmp_img = imagecreatetruecolor($new_width, $new_height);

	        	# Copy and resize old image into new image
			imagecopyresampled($tmp_img, $img, 0, 0, 0, 0,
				$new_width, $new_height, $width, $height);
			imagedestroy($img);
			$img = $tmp_img;
	
			switch ($imgtype) {
			case 'jpg':
				imagejpeg($img,$cache.md5($image_path.$msize));
				break;
			case 'png':
				imagepng($img,$cache.md5($image_path.$msize));
				break;
			case 'gif':
				imagegif($img,$cache.md5($image_path.$msize));
				break;
			case 'bmp':
				imagewbmp($img,$cache.md5($image_path.$msize));
				break;
			}
		}
	}
	# Create error image if necessary
	if (!$img) {
		$img = imagecreate(MAX_WIDTH, MAX_HEIGHT);
		imagecolorallocate($img,0,0,0);
		$c = imagecolorallocate($img,255,0,0);
		imageline($img,0,0,MAX_WIDTH,MAX_HEIGHT,$c);
		imageline($img,MAX_WIDTH,0,0,MAX_HEIGHT,$c);
		$imgtype = 'jpg';
	}
}

# Display the image
switch ($imgtype) {
	case 'jpg':
		header("Content-type: image/jpeg");
		imagejpeg(@imagecreatefromjpeg($cache.md5($image_path.$msize)));
		break;
	case 'png':
		header("Content-type: image/png");
		imagepng(@imagecreatefrompng($cache.md5($image_path.$msize)));
		break;
	case 'gif':
		header("Content-type: image/gif");
		imagegif(@imagecreatefromgif($cache.md5($image_path.$msize)));
		break;
	case 'bmp':
		header("Content-type: image/wbmp");
		imagewbmp(@imagecreatefromwbmp($cache.md5($image_path.$msize)));
		break;
}

?>
